#include <iostream>
#include <cstdio>
#include <string>
#include <cstring>
#include <map>
#include <set>
#include <stack>
#include <queue>
#include <vector>
#include <cmath>
#include <algorithm>
#include <ctime>
#include <cstdlib>
#include <cassert>

using namespace std;
#define forn(i, n) for (int i = 0; i < n; ++i)
#define ALL(a) a.begin(), a.end()
#define X first
#define Y second
#define sz(a) ((int)a.size())
#define L(a) sz(a)
#define pb(a) push_back(a)
#define mp(a, b) make_pair(a, b)
#define ms(a) memset(a,0,sizeof(a))
#define ms1(a) memset(a,-1,sizeof(a))

typedef long long ll;
typedef unsigned long long ull;
typedef long double ld;
typedef pair<int, int> pii;

const double PI = 3.1415926535897932384626433832795;

const int mod = 1000000007;

struct num {
	int x;
	num():x(0) {}
	num(int x):x(x) {}
	num operator+(const num& o) const {
		num res(x+o.x);
		if (res.x >= mod) res.x -= mod;
		return res;
	}
	num operator-(const num& o) const {
		num res(x-o.x);
		if (res.x < 0) res.x += mod;
		return res;
	}

	num operator*(const num& o) const {
		return num(x*(ll)o.x%mod);
	}

	num pw(int n) const {
		num res(1);
		num t = *this;
		while (n) {
			if (n&1) res = res * t;
			t = t * t;
			n >>= 1;
		}
		return res;
	}

	num getrev() const {
		return pw(mod-2);
	}
};

num comb(ll n, int k) {
	num ans(1);
	forn(i, k) ans = ans * num((n-i)%mod);
	for(int i = 1; i <= k; ++i) {
		num rv = num(i).getrev();
		ans = ans * rv;
	}
	return ans;
}

bool solve() {
	int N, X;
	ll D;
	cin >> N >> D >> X;
	if (N == 0 && D == 0 && X == 0) return false;
	--X;
	vector<vector<num> > dp(N+1, vector<num>(N+1));
	vector<vector<num> > psum(N+1, vector<num>(N+1));
	dp[0][0] = num(1);
	forn(i, N) psum[0][i] = num(1);
	for (int i = 1; i <= N; ++i) {
		for (int j = 1; j <= N; ++j) {
			int to = j-1;
			int fr = j-X;
			if (fr <= to) {
				dp[i][j] = psum[i-1][to];
				if (fr > 0) dp[i][j] = dp[i][j] - psum[i-1][fr-1];
			}
		}
		psum[i][0] = dp[i][0];
		for (int j = 1; j <= N; ++j) psum[i][j] = psum[i][j-1] + dp[i][j];
	}
	num ans(0);
	for (int i = 1; i <= N; ++i) {
		ll rem = D-i;
		if (rem < 0) continue;
		num curadd = dp[i][N];
		curadd = curadd * comb(D, i);
		ans = ans + curadd;
	}
	printf("%d\n", ans.x);
	return true;
}

int main() {
#ifdef _DEBUG
	freopen("input.txt", "r", stdin);
	//freopen("output.txt", "w", stdout);
#else
	/*freopen("input.txt", "r", stdin);
	freopen("output.txt", "w", stdout);*/
#endif
	while (solve());
	return 0;
}
